 ; Ŀ
 ;   Foap - find the zero based position of an attribute in a block.       
 ;   Also contains:                                                        
 ;   Acho, temporarily replace attribute values with attribute tags.       
 ;   Defa, put the default values back into the attributes.                
 ;   Fap, replace attribute values with sequential numbers.                
 ;   Faap, append sequential numbers to all attribute values.              
 ;   Don't forget that all of these are zero based - the first number is   
 ;   zero, not one.                                                        
 ;   Xae, empty all attributes in selected blocks.                         
 ;   Xa-, replace all attribute values in selected blocks with "-"         
 ;   Xad, replace all attribute values in selected blocks with "..."       
 ;   Xat, replace all attribute values in selected blocks with "XX".       
 ;   Copyright 2002 - 2008 by Rocket Software Ltd.                         
 ;   Dedicated to the nice people at the Screamin' Skulls Daycare.         
 ; 

 ; Ŀ
 ;   Acho - Put tag names into attributes.                                 
 ;   Copyright 1993, 1995, 2004 by Rocket Software Ltd.                    
 ; 
 (DEFUN C:ACHO (/ enam esav entt tagg vall sublst main pos)
  (command "undo" "m")
  (setq enam (car (entsel "Block:")))
  (setq entt (entget (setq esav enam)))
 ; Ŀ
 ;   Step through the insert, substituting the tag names for attribute     
 ;   values, save the original values so they can be restored.             
 ; 
  (if (and (= (cdr (assoc 0 entt)) "INSERT")
           (assoc 66 entt))
      (progn
           (while (/= (cdr (assoc 0 entt)) "SEQEND")
                  (setq enam (entnext enam))
                  (setq entt (entget enam))
                  (setq tagg (cdr (assoc 2 entt)))
                  (setq vall (cdr (assoc 1 entt)))
                  (if (and tagg vall)
                      (progn
                           (setq sublst (list tagg vall))
                           (setq main (append main (list sublst)))
                           (entmod (subst (cons 1 tagg)
                                          (cons 1 vall) entt)))))
           (entupd esav)
 ; Ŀ
 ;   Stop while the user looks at the modified block.                      
 ; 
           (getstring "\nContinue: ")
 ; Ŀ
 ;   Restore the original values to the block from the list Main.          
 ; 
           (setq entt (entget (setq enam esav)))
           (setq pos 0)
           (while (/= (cdr (assoc 0 entt)) "SEQEND")
                  (setq enam (entnext enam))
                  (setq entt (entget enam))
                  (setq sublst (nth pos main))
                  (setq vall (cadr sublst))
                  (setq pos (1+ pos))
                  (entmod (subst (cons 1 vall) (assoc 1 entt) entt)))
           (entupd esav)))
 (princ))

 ; Ŀ
 ;   Subroutine Defa - search a block definition for attribute defaults.   
 ;   Argument: Blnam, a block name.                                        
 ;   Returns a list in order.                                              
 ; 
 (DEFUN DEFA (blnam / blok namm entt pr prlist)
  (setq blok (tblsearch "block" blnam))           ; the head entity
  (setq namm (cdr (assoc -2 blok)))               ; first ename after head
  (while namm                                     ; while there is an entity
         (setq entt (entget namm))                ; the whole thing
         (if (= (cdr (assoc 0 entt)) "ATTDEF")
             (progn
                  (setq pr (cdr (assoc 1 entt)))
                  (setq prlist (append prlist (list pr)))))
         (setq namm (entnext namm)))              ; next subentity ename
 prlist)
 ; Ŀ
 ;   Defa end.                                                             
 ; 

 ; Ŀ
 ;   Fap - utility - number the attributes in a block.                     
 ; 
 (DEFUN C:FAP (/ enampt enam esav num entt)
  (if (and (setq enampt (entsel "Block to number: "))
           (setq esav (setq enam (car enampt)))
           (assoc 66 (entget enam)))
      (progn
           (setq num 0)
           (while (/= "SEQEND" (cdr (assoc 0 (setq entt
                                    (entget (setq enam (entnext enam)))))))
                  (entmod (subst (cons 1 (itoa num)) (assoc 1 entt) entt))
                  (setq num (1+ num)))
           (entupd esav))
      (write-line "\nThat was not a block with attributes."))
 (princ))

 ; Ŀ
 ;   Subroutine Xatt: place a value in every attribute in a block.         
 ;   Arguments: Enam, a block ename.                                       
 ;              Vala, a string.                                            
 ; 
 (DEFUN XATT (enam vala / esav entt)
  (setq esav enam)
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt
                                    (entget (setq enam (entnext enam)))))))
         (entmod (subst (cons 1 vala) (assoc 1 entt) entt)))
  (entupd esav)
 (princ))
 ; Ŀ
 ;   Subroutine Xatt end.                                                  
 ; 

 ; Ŀ
 ;   Xat - replace all attribute values in selected blocks.                
 ;   Arguments: Proma, the final part of the prompt string.                
 ;              Vala, a string.                                            
 ; 
 (DEFUN XAT (proma vala / ss num enam)
  (prompt (strcat "Select blocks to " proma ":"))
  (if (setq ss (ssget (list (cons 0 "INSERT") (cons 66 1))))
      (progn
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (xatt enam vala))))
 (princ))
 ; Ŀ
 ;   Subroutine Xat end.                                                   
 ; 

 ; Ŀ
 ;   Defa - put default attribute values back into a block.                
 ; 
 (DEFUN C:DEFA (/ snapp *error* ss num esav enam blnam deflis entt vala)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (setvar "snapmode" snapp)
   (command ".undo" "end")
   (if shk (write-line shk))
  (princ))
 ; Ŀ
 ;   Get an ss of block insertions.                                        
 ; 
  (prompt "Blocks to Defaultify: ")
  (setq ss (ssget (list (cons 0 "INSERT") (cons 66 1))))
 ; Ŀ
 ;   While there are blocks in the ss.                                     
 ; 
  (setq num 0)
  (while (setq esav (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq blnam (cdr (assoc 2 (entget enam))))
 ; Ŀ
 ;   Get a list of default attribute values.                               
 ; 
         (setq deflis (defa blnam))
 ; Ŀ
 ;   Reapply the defaults to the block.                                    
 ; 
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt
                                      (entget (setq enam (entnext enam)))))))
                (setq vala (car deflis))
                (setq deflis (cdr deflis))
 ; Ŀ
 ;   The next line covers something that can't happen, but might.          
 ; 
                (if (null vala) (setq vala ""))
                (entmod (subst (cons 1 vala) (assoc 1 entt) entt)))
 ; Ŀ
 ;   Regenerate the insertion entity.                                      
 ; 
                (entupd esav))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))

 ; Ŀ
 ;   Xad - replace all attribute values in selected blocks with "..."      
 ; 
 (DEFUN C:XAD ()
  (xat "..." "...")
 (princ))

 ; Ŀ
 ;   Xa- - replace all attribute values in selected blocks with "-"        
 ; 
 (DEFUN C:XA- ()
  (xat "dash" "-")
 (princ))

 ; Ŀ
 ;   Xae - empty all attributes in selected blocks.                        
 ; 
 (DEFUN C:XAE ()
  (xat "empty" "")
 (princ))

 ; Ŀ
 ;   Xat - replace all attribute values in selected blocks with "XX".      
 ; 
 (DEFUN C:XAT ()
  (xat "XX" "XX")
 (princ))

 ; Ŀ
 ;   Faap - utility - append sequential numbers to the attribute values.   
 ; 
 (DEFUN C:FAAP (/ enampt enam esav num entt val)
  (if (and (setq enampt (entsel "Block to number: "))
           (setq esav (setq enam (car enampt)))
           (assoc 66 (entget enam)))
      (progn
           (setq num 0)
           (while (/= "SEQEND" (cdr (assoc 0 (setq entt
                                    (entget (setq enam (entnext enam)))))))
                  (setq val (cdr (setq asoc1 (assoc 1 entt))))
                  (setq val (strcat val " (" (itoa num) ")"))
                  (entmod (subst (cons 1 val) asoc1 entt))
                  (setq num (1+ num)))
           (entupd esav))
      (write-line "\nThat was not a block with attributes."))
 (princ))

 ; Ŀ
 ;   Foap.                                                                 
 ; 
 (DEFUN C:FOAP (/ enampt atenam blopt enam blnam num fini)
  (if (and (setq enampt (entsel "Attribute to locate: "))
           (setq enam (car enampt))
           (setq blnam (cdr (assoc 2 (entget enam))))
           (setq blopt (cadr enampt))
           (setq entt (entget (car (nentselp blopt))))
           (setq attnam (cdr (assoc 2 entt)))
           (setq atenam (cdr (assoc -1 entt))))
      (progn
           (setq num 0)
           (while (/= "SEQEND" (cdr (assoc 0
                                    (entget (setq enam (entnext enam))))))
                  (if (equal atenam enam) (setq fini num))
                  (setq num (1+ num)))
           (write-line (strcat "\nAttribute " attnam
                               " occupies position " (itoa fini)
                               " in block " blnam ".")))
      (write-line "\nProgram Failure."))
 (princ))